<?php
/**
 * Reader.php 2020-3-24
 * Gambio GmbH
 * http://www.gambio.de
 * Copyright (c) 2020 Gambio GmbH
 * Released under the GNU General Public License (Version 2)
 * [http://www.gnu.org/licenses/gpl-2.0.html]
 */

namespace Gambio\Shop\Attributes\SellingUnitQuantitiy\Database\Repository\Reader;


use Doctrine\DBAL\Connection;
use Gambio\Shop\Attributes\SellingUnitModel\Database\Repository\DTO\AttributesModelDto;
use Gambio\Shop\Attributes\SellingUnitQuantitiy\Database\Repository\DTO\AttributeInfo;

class Reader implements ReaderInterface
{
    /**
     * @var Connection
     */
    protected $connection;

    /**
     * Reader constructor.
     * @param Connection $connection
     */
    public function __construct(Connection $connection)
    {
        $this->connection = $connection;
    }

    /**
     * @inheritDoc
     */
    public function getQuantity(int $productId, int $modifierIdentifierId): AttributeInfo
    {
        $records = $this->connection
            ->createQueryBuilder()
            ->select('attributes_stock')
            ->from('products_attributes')
            ->where('products_id = :products_id ')
            ->andWhere('options_values_id = :options_values_id')
            ->setParameter('products_id',$productId)
            ->setParameter('options_values_id', $modifierIdentifierId)
            ->execute()
            ->fetchAll();
            
        if(count($records)){
            return new AttributeInfo((float)$records[0]['attributes_stock']);
        }

        return new AttributeInfo((float)0);
    }
}